Unit frmConeCalculations;

Interface

Uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, pngimage, ExtCtrls, Buttons;

Type
  TForm1 = Class(TForm)
    btnSlantHeight: TButton;
    btnVolume: TButton;
    btnSurfaceArea: TButton;
    Memo1: TMemo;
    Label1: TLabel;
    Image1: TImage;
    Image2: TImage;
    Label2: TLabel;
    sbnNewCone: TSpeedButton;
    Procedure FormCreate(Sender: TObject);
    Procedure btnSlantHeightClick(Sender: TObject);
    Procedure btnVolumeClick(Sender: TObject);
    Procedure btnSurfaceAreaClick(Sender: TObject);
    Procedure Button5Click(Sender: TObject);
    Procedure Button6Click(Sender: TObject);
    procedure sbnNewConeClick(Sender: TObject);
  Private
    { Private declarations }

  Public
    { Public declarations }

  End;

Var
  Form1: TForm1;

Implementation

Uses
  ConeClass;

VAR
  myCone: Tcone;
{$R *.dfm}

Procedure TForm1.btnSlantHeightClick(Sender: TObject);
Var
  slantHeight: Double;

Begin
  Memo1.Lines.Add(format('%sSlant height = %15.5f', [sLineBreak,myCone.slantHeight]));
  Image2.Stretch := True;
  Image2.Picture.LoadFromFile('SlantHeight2.png');
End;

Procedure TForm1.btnVolumeClick(Sender: TObject);
Begin
  Memo1.Lines.Add(format('%sVolume = %15.5f', [sLineBreak,myCone.volume]));
  Image2.Stretch := True;
  Image2.Picture.LoadFromFile('Volume.png');
  End;

Procedure TForm1.btnSurfaceAreaClick(Sender: TObject);
Begin
  Memo1.Lines.Add(format('%sSurface area = %15.5f', [sLineBreak,
      myCone.surfaceArea]));
  Image2.Stretch := True;
  Image2.Picture.LoadFromFile('SurfaceArea.png');
End;

Procedure TForm1.Button5Click(Sender: TObject);
Begin
  myCone.setDiameter(StrToFloat(inputbox('Cone calculator',
        'Enter diameter of cone', '12.6')));
  Memo1.Lines.Add(myCone.toString);
End;

Procedure TForm1.Button6Click(Sender: TObject);
Begin
  myCone.setHeight(StrToFloat(inputbox('Cone calculator',
        'Enter height of cone', '7.4')));
  Memo1.Lines.Add(myCone.toString);
End;

Procedure TForm1.FormCreate(Sender: TObject);
Begin
  Memo1.Lines.Text := format('Calculations for cone %s', [sLineBreak]);
 End;

procedure TForm1.sbnNewConeClick(Sender: TObject);
Var
  height: Double;
  diameter: Double;
Begin
  height := StrToFloat(inputbox('Cone calculator', 'Enter height of cone',
      '10.5'));
  diameter := StrToFloat(inputbox('Cone calculator', 'Enter height of cone',
      '8.6'));
  myCone := Tcone.Create(height, diameter);
   Memo1.Lines.Text := format('Calculations for cone %s', [sLineBreak]);
  Memo1.Lines.Add(format('%sNew Cone object created: %0:s%s', [sLineBreak,
      myCone.toString]));
  btnSlantHeight.Enabled := true;
  btnVolume.Enabled := true;
  btnSurfaceArea.Enabled := true;
end;

End.
